#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/wf/header.h"
#include "levels/bbh/header.h"

extern u8 _wf_segment_ESegmentRomStart[];
extern u8 _wf_segment_ESegmentRomEnd[];

const LevelScript level_wf_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _bbh_segment_7SegmentRomStart, _bbh_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _bbhSegmentRomStart, _bbhSegmentRomEnd),
LOAD_RAW(0x0E, _wf_segment_ESegmentRomStart, _wf_segment_ESegmentRomEnd),
LOAD_MIO0(0xA, _water_skybox_mio0SegmentRomStart, _water_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group9_mio0SegmentRomStart, _group9_mio0SegmentRomEnd),
LOAD_RAW(12, _group9_geoSegmentRomStart, _group9_geoSegmentRomEnd),
LOAD_MIO0(6, _group14_mio0SegmentRomStart, _group14_mio0SegmentRomEnd),
LOAD_RAW(13, _group14_geoSegmentRomStart, _group14_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_BBH_HAUNTED_DOOR,           haunted_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_BBH_STAIRCASE_STEP,         geo_bbh_0005B0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TILTING_FLOOR_PLATFORM, geo_bbh_0005C8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM,      geo_bbh_0005E0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM_PART, geo_bbh_0005F8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MOVING_BOOKSHELF,       geo_bbh_000610),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MESH_ELEVATOR,          geo_bbh_000628),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MERRY_GO_ROUND,         geo_bbh_000640),
LOAD_MODEL_FROM_GEO(MODEL_BBH_WOODEN_TOMB,            geo_bbh_000658),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_10),
JUMP_LINK(script_func_global_15),
JUMP_LINK(local_area_wf_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_wf_1_[] = {
AREA(1, Geo_wf_1_0x1359bf0),
TERRAIN(col_wf_1_0xe068d80),
SET_BACKGROUND_MUSIC(0, 39),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_wf_1_),
JUMP_LINK(local_warps_wf_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_wf_1_[] = {
OBJECT_WITH_ACTS(0, 0, 1024, 6700, 0, 180, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(122, 6627, 2500, -4791, 0, 0, 0, 0x2000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, 0, 500, -7250, 0, 0, 0, 0x3000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, 4500, 1815, 4300, 0, 0, 0, 0x5000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, -6765, 6000, 3850, 0, 0, 0, 0x1000000,  bhvStar, 31),
OBJECT_WITH_ACTS(201, 0, 140, -3963, 0, 0, 0, 0x400000,  bhvCannonClosed, 31),
OBJECT_WITH_ACTS(195, 3800, 2249, -1297, 0, 0, 0, 0x0,  bhvBobombBuddyOpensCannon, 31),
OBJECT_WITH_ACTS(122, 0, 600, 2875, 0, 0, 180, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(122, 0, 600, 650, 0, 180, 180, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(122, -1125, 1000, 1750, 0, 270, 180, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, -2503, 1000, 1752, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(122, 1125, 1000, 1750, 0, 90, 180, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 0, 2000, 3650, 0, 90, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(122, 0, 500, 1750, 0, 0, 180, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 0, 0, 1750, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 0, 3000, -2150, 0, 0, 0, 0x0,  bhvHiddenStar, 31),
OBJECT_WITH_ACTS(137, 6525, 3010, -1260, 0, 0, 0, 0x20000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(207, -6712, 2500, 1975, 0, 0, 0, 0x0,  bhvFloorSwitchHiddenObjects, 31),
OBJECT_WITH_ACTS(129, -6769, 2500, 3328, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -6329, 3280, 3817, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -6789, 4090, 4287, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -7199, 4900, 3828, 0, 0, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -7115, 4510, 4172, 0, 45, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -6426, 3700, 4169, 0, 45, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(129, -6399, 2890, 3491, 0, 45, 0, 0x0,  bhvHiddenObject, 31),
OBJECT_WITH_ACTS(215, 4124, 2330, -1899, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 3822, 2180, 540, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 6428, 2180, 4997, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 5274, 2090, 6695, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -5471, 1700, 7249, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -4240, 2240, 2732, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -6316, 2240, -190, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -4694, 2240, -3338, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(0, -4216, 2500, 4507, 0, 0, 0, 0x4000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(223, -4789, 2200, 4401, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(102, -3698, 250, 6552, 0, 0, 0, 0x0,  bhvChainChomp, 31),
OBJECT_WITH_ACTS(223, 4103, 1500, -4854, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, 6651, 2000, -3715, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(212, 37, 2030, -7254, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(212, 276, 2030, -7255, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(212, -203, 2030, -7267, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(103, 2760, 0, 6474, 0, 180, 0, 0x0,  bhvSmallWhomp, 31),
OBJECT_WITH_ACTS(188, 444, -1000, 4574, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -500, -1000, 4325, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -1327, 0, -678, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -33, 0, -889, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, 1516, 0, -376, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -5127, 2000, 3851, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -6859, 2000, 5535, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -4047, 2000, 3549, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, 4482, 2000, -1531, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, 6311, 2000, -1462, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, 6548, 2000, 1889, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(103, 5539, 2000, -1435, 0, 0, 0, 0x0,  bhvSmallWhomp, 31),
OBJECT_WITH_ACTS(107, 5543, 2000, 1503, 0, 0, 0, 0x0,  bhvWoodenPost, 31),
OBJECT_WITH_ACTS(107, 3479, 2000, 3248, 0, 0, 0, 0x0,  bhvWoodenPost, 31),
OBJECT_WITH_ACTS(0, 5429, 1700, 6111, 0, 90, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(140, 5201, 2000, -4763, 0, 0, 0, 0x0,  bhvBlueCoinSwitch, 31),
OBJECT_WITH_ACTS(118, 3660, 191, -760, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 4311, 578, -1099, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 4851, 962, -1641, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 5114, 1353, -2366, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 5187, 1500, -3165, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 5199, 1760, -4102, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(0, 2777, 0, 1818, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(107, 2062, 0, 1753, 0, 0, 0, 0x0,  bhvWoodenPost, 31),
OBJECT_WITH_ACTS(0, -42, 500, -2173, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -42, 1500, -2173, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -42, 2500, -2173, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(137, 4443, 2000, 4739, 0, 0, 0, 0x60000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 3521, 1870, 4500, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(188, 6703, 2000, 60, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, 6698, 2000, 1199, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(0, 7360, 2000, 656, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(188, 1326, 0, -2559, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -2559, 0, -2991, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(0, -2515, 1250, -598, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 4662, 2770, -1424, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(129, -4403, 2000, -845, 0, 0, 0, 0x10000,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(129, -5570, 2000, -547, 0, 0, 0, 0x10000,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(129, -6348, 2000, -3540, 0, 0, 0, 0x10000,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(129, -5209, 2000, -3529, 0, 0, 0, 0x10000,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(124, 2760, 0, -3875, 0, 0, 0, 0x120000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(0, -2642, 760, 6880, 0, 0, 0, 0x0,  bhvHidden1upInPoleSpawner, 31),
OBJECT_WITH_ACTS(212, 0, 2180, 1085, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(0, 6556, 3000, -3036, 0, 0, 0, 0x40000,  bhvCoinFormation, 31),
RETURN()
};

const LevelScript local_warps_wf_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(240, 6, 1, 42, 0),
WARP_NODE(241, 6, 1, 52, 0),
RETURN()
};
